#ifndef _DORECEIVE_CPP
#define _DORECEIVE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoRecv(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoRecv.\n");
    #endif

	//The data received exceeds our local receive buffer size.
	if(icRecvBufSz[iClient] > IDEAL_RECV_SIZE)
	{
		return false;
	}

    char sLocalRecvBuf[IDEAL_RECV_SIZE + 1];
    int iResult = 0;

	if((iResult = recv(sckcSocket[iClient], sLocalRecvBuf, IDEAL_RECV_SIZE, 0)) == SOCKET_ERROR)
	{
		bcDisconnect[iClient] = true;
		return false;
	}
	else if(iResult == 0) // Gracefull disconnect
	{
		bcDisconnect[iClient] = true;
		return false;
	}

	if(!Events.OnRecv(this, iClient, sLocalRecvBuf, iResult))
	{
		return true; //All is well.
	}

	icRecvOffset[iClient] = 0;

    if(bcConnected[iClient] && !bcDisconnect[iClient])
    {
		if((icRecvBufSz[iClient] + iResult) >= icMaxRecvBufSz[iClient])
		{
			if(!ResizeRecvBuffer(iClient, (icRecvBufSz[iClient] + iResult) + 1))
			{
				return false;
			}
		}

		//The client receive buffer IS empty, so just COPY the received data to it.
		if(icRecvBufSz[iClient] == 0)
		{
			memcpy(scRecvBuf[iClient], sLocalRecvBuf, iResult);
	        icRecvBufSz[iClient] = iResult;
		}
		else{
			//The client receive buffer NOT is empty, APPEND the received data to it.
			int iRPos = 0;
			int iWPos = icRecvBufSz[iClient];

			while(iRPos < iResult)
			{
				scRecvBuf[iClient][iWPos] = sLocalRecvBuf[iRPos];
				iRPos++;
				iWPos++;
			}
			icRecvBufSz[iClient] = (icRecvBufSz[iClient] + iResult);
		}
	}
    else return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
